<?php
require '../dbconn.php';

header("Content-Type: application/json");
header('Access-Control-Allow-Origin: http://localhost:5173');
// Allow all origins
header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); // Allow specific HTTP methods
header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control'); // Allow specific headers
header('Content-Type: application/json');
require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;




$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        http_response_code(400); // Unauthorized
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}

// Validate user_id
if (!$user_id) {
    echo json_encode(['status' => 'error', 'message' => 'Missing user_id']);
    exit;
}

// Query to fetch shipping addresses
$query = "SELECT id, first_name, last_name, phone_number, pincode, flat_building, area_street, landmark, city, state, country 
          FROM shipping_addresses WHERE user_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $user_id);

if ($stmt->execute()) {
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $addresses = [];
        while ($row = $result->fetch_assoc()) {
            $addresses[] = $row;
        }

        echo json_encode([
            'status' => 'success',
            'message' => 'Shipping addresses retrieved successfully',
            'data' => $addresses
        ]);
    } else {
        echo json_encode([
            'status' => 'false',
            'message' => 'No shipping addresses found for this user',
            'data' => []
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Error retrieving shipping addresses: ' . $conn->error
    ]);
}

$stmt->close();
$conn->close();
?>
