<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

header("Content-Type: application/json");
require '../dbconn.php'; // Include database connection

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
    exit;
}

// Ensure required fields are set
if (!isset($_POST['product_id'], $_POST['status_type'], $_POST['status'])) {
    echo json_encode(["success" => false, "message" => "Missing required fields"]);
    exit;
}

$product_id = (int)$_POST['product_id'];
$status_type = $_POST['status_type']; // "latest" or "best_seller"
$status = ($_POST['status'] == "true") ? 1 : 0;

if (!in_array($status_type, ['latest', 'best_seller'])) {
    echo json_encode(["success" => false, "message" => "Invalid status type"]);
    exit;
}

// Determine the column to update
$column = ($status_type == "latest") ? "is_latest" : "is_best_seller";
$opposite_column = ($status_type == "latest") ? "is_best_seller" : "is_latest";

$conn->begin_transaction();

try {
    // Update the selected column
    $sql = "UPDATE products SET $column = ?, $opposite_column = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $opposite_status = $status ? 0 : "is_$opposite_column"; // Keep the other column unchanged if setting false
    $stmt->bind_param("iii", $status, $opposite_status, $product_id);
    
    if ($stmt->execute()) {
        $conn->commit();
        echo json_encode(["success" => true, "message" => "Product status updated successfully"]);
    } else {
        throw new Exception("Failed to update product status");
    }
} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(["success" => false, "message" => $e->getMessage()]);
}
?>
