<?php
require '../dbconn.php';

// Allow CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

$review_id = $_POST['id'] ?? null;
$review_text = $_POST['review_text'] ?? null;
$rating = $_POST['rating'] ?? null;

if (!$review_id || (!$review_text && !$rating)) {
    echo json_encode(['status' => 'error', 'message' => 'Review ID and at least one field to update are required']);
    exit;
}

$fields_to_update = [];
if ($review_text) {
    $fields_to_update[] = "review_text = '$review_text'";
}
if ($rating) {
    $fields_to_update[] = "rating = '$rating'";
}

$query = "UPDATE product_reviews SET " . implode(', ', $fields_to_update) . " WHERE id = '$review_id'";

if ($conn->query($query) === TRUE) {
    echo json_encode(['status' => 'success', 'message' => 'Review updated successfully']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Error updating review: ' . $conn->error]);
}

$conn->close();
?>
