<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Access-Control-Allow-Origin: http://localhost:5173');
// Allow all origins
header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); // Allow specific HTTP methods
header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control'); // Allow specific headers
header('Content-Type: application/json');
require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;




$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        http_response_code(400); // Unauthorized
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
    header("HTTP/1.1 200 OK");
    exit();
}

// Retrieve form data
//$user_id = $_POST['user_id'] ?? null;
$product_id = $_POST['product_id'] ?? null;
$order_id = $_POST['order_id'] ?? null;
$review_text = $_POST['review_text'] ?? null;
$rating = $_POST['rating'] ?? null;
$review_type = $_POST['review_type'] ?? null;  // 'product' or 'delivery'

// Validate required fields
if (!$user_id || !$review_text || !$rating || $rating < 1 || $rating > 5 || !$review_type) {
    echo json_encode(['status' => 'error', 'message' => 'Missing or invalid fields']);
    exit;
}

// Ensure proper ID based on review type
if ($review_type === 'product' && !$product_id) {
    echo json_encode(['status' => 'error', 'message' => 'Product ID is required for product reviews']);
    exit;
} elseif ($review_type === 'delivery' && !$order_id) {
    echo json_encode(['status' => 'error', 'message' => 'Order ID is required for delivery reviews']);
    exit;
}

// Insert review into the database
$query = "INSERT INTO product_reviews (user_id, product_id, order_id, review_type, review_text, rating) 
          VALUES ('$user_id', 
                  " . ($product_id ? "'$product_id'" : "NULL") . ", 
                  " . ($order_id ? "'$order_id'" : "NULL") . ", 
                  '$review_type', 
                  '$review_text', 
                  '$rating')";

if ($conn->query($query) === TRUE) {
    echo json_encode(['status' => 'success', 'message' => 'Review added successfully', 'id' => $conn->insert_id]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Error adding review: ' . $conn->error]);
}

$conn->close();
?>
