<?php

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../env.php';


// require_once '../vendor/autoload.php';
// include '../env.php';

function verifyJWT()
{
    global $secret_key;

    // 1. Try reading token from Cookie
    $token = $_COOKIE['auth_token'] ?? null;

    // 2. Try reading Authorization header (fallback)
    if (!$token && isset($_SERVER['Authorization'])) {
        $authHeader = trim($_SERVER['Authorization']);

        if (strpos($authHeader, 'Bearer ') === 0) {
            $token = substr($authHeader, 7);
        }
    }

    // 3. No token found
    if (!$token) {
        echo json_encode([
            "success" => false,
            "message" => "Unauthorized. Token missing."
        ]);
        http_response_code(401);
        exit;
    }

    try {
        // 4. Decode JWT
        $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));

        // 5. Valid Token → return user
        return [
            "success" => true,
            "data" => (array)$decoded->user
        ];

    } catch (Exception $e) {

        // 6. Invalid token
        echo json_encode([
            "success" => false,
            "message" => "Unauthorized: " . $e->getMessage()
        ]);
        http_response_code(401);
        exit;
    }
}
