<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json');

require '../dbconn.php';
require '../middleware/jwt.php'; // path to your verifyJWT() file

// ----------------------------------
// Verify JWT (From Cookie or Header)
// ----------------------------------
$auth = verifyJWT();

if (!$auth["success"]) {
    echo json_encode([
        "success" => false,
        "message" => "Unauthorized user"
    ]);
    exit;
}

$user = $auth["data"];
$user_role = $user["role"] ?? null;

// Only admin can add category
if ($user_role !== "admin") {
    echo json_encode([
        "success" => false,
        "message" => "Only admin can add categories"
    ]);
    exit;
}

// ----------------------------------
// Validate Input Fields
// ----------------------------------
if (empty($_POST['name']) || empty($_POST['description'])) {
    echo json_encode([
        "success" => false,
        "message" => "Required fields: name, description"
    ]);
    exit;
}

$name = trim($_POST['name']);
$description = trim($_POST['description']);

// ----------------------------------
// Validate & Upload Image
// ----------------------------------
if (!isset($_FILES['image'])) {
    echo json_encode([
        "success" => false,
        "message" => "Image file is required"
    ]);
    exit;
}

$image = $_FILES['image'];

$uploadDir = __DIR__ . "/uploads/";
$uploadUrlBase = "categories/uploads/";

// Create folder if missing
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

// Allowed extensions
$allowedExt = ['jpg', 'jpeg', 'png', 'webp'];
$ext = strtolower(pathinfo($image['name'], PATHINFO_EXTENSION));

if (!in_array($ext, $allowedExt)) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid image format. Allowed: JPG, PNG, WEBP"
    ]);
    exit;
}

$filename = uniqid("cat_") . "." . $ext;
$filepath = $uploadDir . $filename;

if (!move_uploaded_file($image['tmp_name'], $filepath)) {
    echo json_encode([
        "success" => false,
        "message" => "Failed to upload image"
    ]);
    exit;
}

$image_url = $uploadUrlBase . $filename;

// ----------------------------------
// Insert Category in Database
// ----------------------------------
$query = "INSERT INTO categories (name, image_url, description) VALUES (?, ?, ?)";
$stmt = $conn->prepare($query);

$stmt->bind_param("sss", $name, $image_url, $description);

if ($stmt->execute()) {
    echo json_encode([
        "success" => true,
        "message" => "Category added successfully",
        "data" => [
            "category_id" => $stmt->insert_id,
            "name" => $name,
            "image_url" => $image_url,
            "description" => $description
        ]
    ]);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Failed to insert category",
        "mysql_error" => $stmt->error
    ]);
}

$conn->close();
?>
