<?php

header('Content-Type: application/json');

// Restrict only POST method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid request method. Only POST allowed."
    ]);
    exit;
}

// Autoload Composer packages
require_once '../vendor/autoload.php';

// Include DB connection + ENV
include '../dbconn.php';
include '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

// Read POST body
$mobile = $_POST['mobile'] ?? null;
$password = $_POST['password'] ?? null;

// Default response
$response = [
    "status" => "error",
    "message" => "Invalid mobile number or password."
];

// Validate required fields
if (!$mobile || !$password) {
    $response['message'] = "Mobile number and password are required.";
    echo json_encode($response);
    exit;
}

// Fetch user from DB
$query = "SELECT id, name, mobile, email, password_hash, role, is_verified FROM users WHERE mobile = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $mobile);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode($response);
    exit;
}

$user = $result->fetch_assoc();

// Validate password
if (!password_verify($password, $user['password_hash'])) {
    echo json_encode($response);
    exit;
}

// Generate JWT
$issuedAt = time();
$expirationTime = $issuedAt + (60 * 60 * 24); // 1 day
if ($user['is_verified'] != 1) {
    $response['message'] = 'these mobile number is not verified';
    echo json_encode($response);
    exit;
}

$payload = [
    'iss' => 'yourdomain.com',
    'iat' => $issuedAt,
    'exp' => $expirationTime,
    'sub' => $user['id'],
    'user' => [
        'id' => $user['id'],
        'name' => $user['name'],
        'mobile' => $user['mobile'],
        'email' => $user['email'],
        'role' => $user['role'],
        'is_verified' => $user['is_verified']
    ]
];

$jwt = JWT::encode($payload, $secret_key, 'HS256');


// --------------------------------------------------------
// ✅ SET COOKIE BASED ON ROLE
// --------------------------------------------------------
$cookieDomain = "";

switch ($user['role']) {
    case "admin":
        $cookieDomain = "redbag.pmpframe.com";
        break;

    case "user":
        $cookieDomain = "redbag.pmpframe.com";
        break;

    case "super_admin":
        $cookieDomain = "dummy.pmpframe.com";
        break;
}

// Set cookie for 1 day
setcookie(
    "auth_token",
    $jwt,
    time() + (60 * 60 * 24),
    "/",                // path
    $cookieDomain,      // domain
    true,               // secure
    true                // httponly
);


// Final response
$response = [
    "status" => "success",
    "message" => "Login successful.",
    "data" => [
        "token" => $jwt,
        "user" => [
            "name" => $user['name'],
            "mobile" => $user['mobile'],
            "email" => $user['email'],
            "role" => $user['role']
        ]
    ]
];

echo json_encode($response);

$conn->close();
exit;

?>
