<?php

require '../dbconn.php'; // Include the database connection

// Get pagination and filtering parameters
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 10;
$typeFilter = isset($_GET['type']) ? $_GET['type'] : ''; // Optional type filter
$search = isset($_GET['search']) ? trim($_GET['search']) : ''; // Search term
$offset = ($page - 1) * $limit;

$response = [
    'success' => false,
    'message' => 'Failed to retrieve notifications',
    'total_count' => 0,
    'page' => $page,
    'limit' => $limit,
    'notifications' => []
];

try {
    // Construct the WHERE clause for filtering
    $whereClauses = [];
    $params = [];
    $paramTypes = "";
    
    if (!empty($typeFilter)) {
        $whereClauses[] = "type = ?";
        $params[] = $typeFilter;
        $paramTypes .= "s";
    }
    
    if (!empty($search)) {
        $whereClauses[] = "(title LIKE ? OR message LIKE ?)";
        $searchTerm = "%$search%";
        $params[] = $searchTerm;
        $params[] = $searchTerm;
        $paramTypes .= "ss";
    }
    
    $whereSQL = !empty($whereClauses) ? " WHERE " . implode(" AND ", $whereClauses) : "";
    
    // Get total count of unique notifications based on filtering
    $countQuery = "SELECT COUNT(*) AS total FROM (
                      SELECT title, message, created_at 
                      FROM notifications 
                      $whereSQL
                      GROUP BY title, message, created_at
                  ) AS grouped";
    
    $countStmt = $conn->prepare($countQuery);
    if (!empty($params)) {
        $countStmt->bind_param($paramTypes, ...$params);
    }
    $countStmt->execute();
    $countResult = $countStmt->get_result();
    $totalCount = ($countResult->num_rows > 0) ? $countResult->fetch_assoc()['total'] : 0;
    
    // Fetch notifications with pagination
    $query = "SELECT title, message, deep_link, type, is_read, read_at, created_at, COUNT(*) AS count 
              FROM notifications 
              $whereSQL
              GROUP BY title, message, created_at 
              ORDER BY created_at DESC 
              LIMIT ? OFFSET ?";
    
    $stmt = $conn->prepare($query);
    
    // Bind parameters dynamically
    $paramTypes .= "ii";
    $params[] = $limit;
    $params[] = $offset;
    $stmt->bind_param($paramTypes, ...$params);
    
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        $notifications = [];

        while ($row = $result->fetch_assoc()) {
            $notifications[] = [
                'title' => $row['title'],
                'message' => $row['message'],
                'deep_link' => $row['deep_link'],
                'is_read' => (bool) $row['is_read'],
                'read_at' => $row['read_at'],
                'created_at' => $row['created_at'],
                'type' => $row['type'],
                'count' => $row['count']
            ];
        }

        $response['success'] = true;
        $response['message'] = 'Notifications retrieved successfully';
        $response['total_count'] = $totalCount;
        $response['notifications'] = $notifications;
    } else {
        $response['message'] = 'No notifications found';
    }
} catch (Exception $e) {
    $response['message'] = 'Error: ' . $e->getMessage();
}

header('Content-Type: application/json');
echo json_encode($response, JSON_PRETTY_PRINT);

?>
