<?php
header('Content-Type: application/json');
require_once '../dbconn.php'; // Ensure this file has a function dbConnect()

// Enable error reporting for debugging (remove in production)
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Check if request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Get POST data with proper handling
$user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
$title = trim($_POST['title'] ?? '');
$message = trim($_POST['message'] ?? '');
$deep_link = trim($_POST['deep_link'] ?? '');
$type = trim($_POST['type'] ?? 'CUSTOM');

// Validate required fields
if ($user_id <= 0 || empty($title) || empty($message)) {
    echo json_encode(["status" => "error", "message" => "User ID, title, and message are required"]);
    exit;
}

// Check database connection
if (!$conn) {
    echo json_encode(["status" => "error", "message" => "Database connection failed"]);
    exit;
}

// Check if user exists
$query = "SELECT id FROM users WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(["status" => "error", "message" => "User not found"]);
    exit;
}

// Prepare the SQL statement to insert a notification
$stmt = $conn->prepare("INSERT INTO notifications (user_id, type, title, message, deep_link, is_read, created_at) VALUES (?, ?, ?, ?, ?, 0, NOW())");
$stmt->bind_param("issss", $user_id, $type, $title, $message, $deep_link);

// Execute and respond
if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Notification sent successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to send notification"]);
}

$stmt->close();
$conn->close();
?>
