<?php
header('Content-Type: application/json');
require_once '../dbconn.php'; // Ensure this file has a function dbConnect()

// Enable error reporting for debugging (remove in production)
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Check if request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Get POST data with proper handling
$title = trim($_POST['title'] ?? '');
$message = trim($_POST['message'] ?? '');
$deep_link = trim($_POST['deep_link'] ?? '');
$type = trim($_POST['type'] ?? 'CUSTOM');
$users = $_POST['users'] ?? 'all'; // Can be "all" or an array

// Validate required fields
if (empty($title) || empty($message)) {
    echo json_encode(["status" => "error", "message" => "Title and message are required"]);
    exit;
}


if (!$conn) {
    echo json_encode(["status" => "error", "message" => "Database connection failed"]);
    exit;
}

// Fetch all user IDs if "all" is selected
$userIds = [];
if ($users === "all") {
    $query = "SELECT id FROM users";
    $result = $conn->query($query);
    while ($row = $result->fetch_assoc()) {
        $userIds[] = $row['id'];
    }
} else {
    $decodedUsers = json_decode($users, true);
    if (!is_array($decodedUsers)) {
        echo json_encode(["status" => "error", "message" => "Invalid users data format"]);
        exit;
    }
    $userIds = array_map('intval', $decodedUsers); // Ensure IDs are integers
}

// Ensure users exist before inserting notifications
if (empty($userIds)) {
    echo json_encode(["status" => "error", "message" => "No valid users found"]);
    exit;
}

// Prepare the SQL statement
$stmt = $conn->prepare("INSERT INTO notifications (user_id, type, title, message, deep_link, is_read, created_at) VALUES (?, ?, ?, ?, ?, 0, NOW())");

// Insert notifications
$inserted = 0;
foreach ($userIds as $user_id) {
    $stmt->bind_param("issss", $user_id, $type, $title, $message, $deep_link);
    if ($stmt->execute()) {
        $inserted++;
    }
}
$stmt->close();
$conn->close();

// Response
if ($inserted > 0) {
    echo json_encode(["status" => "success", "message" => "Notification sent to $inserted user(s)"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to send notifications"]);
}
?>
