<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Content-Type: application/json");

require '../dbconn.php';

// METHOD CHECK
if ($_SERVER['REQUEST_METHOD'] !== "POST") {
    echo json_encode(["success" => false, "message" => "Invalid request method."]);
    exit;
}

// FORM DATA
$id = $_POST["category_id"] ?? null;
$name = $_POST["name"] ?? null;
$description = $_POST["description"] ?? null;

if (!$id) {
    echo json_encode(["success" => false, "message" => "category_id is required"]);
    exit;
}

// FETCH OLD
$sql_old = "SELECT image_url FROM categories WHERE category_id = ?";
$stmt_old = $conn->prepare($sql_old);
$stmt_old->bind_param("i", $id);
$stmt_old->execute();
$res = $stmt_old->get_result();

if ($res->num_rows === 0) {
    echo json_encode(["success" => false, "message" => "Category not found"]);
    exit;
}

$old = $res->fetch_assoc();
$oldImage = $old["image_url"];

// ===============================
// FIXED IMAGE UPLOAD SECTION
// ===============================
$newImage = $oldImage;

if (isset($_FILES["image"]) && $_FILES["image"]["error"] === 0) {

    // Actual folder that exists in your project root
    $upload_folder = __DIR__ . "/../../uploads/categories/";

    if (!is_dir($upload_folder)) {
        mkdir($upload_folder, 0777, true);
    }

    $img_name = time() . "_" . basename($_FILES["image"]["name"]);
    $img_path = $upload_folder . $img_name;

    // Move file
    if (!move_uploaded_file($_FILES["image"]["tmp_name"], $img_path)) {
        echo json_encode([
            "success" => false,
            "message" => "Image upload failed (moving failed)"
        ]);
        exit;
    }

    // Delete old image
    if ($oldImage && file_exists($upload_folder . basename($oldImage))) {
        unlink($upload_folder . basename($oldImage));
    }

    // Correct stored path (URL usable by frontend)
    $newImage = "uploads/categories/" . $img_name;
}

// ===============================
// BUILD DYNAMIC UPDATE QUERY
// ===============================
$fields = [];
$params = [];
$types  = "";

if ($name !== null) {
    $fields[] = "name = ?";
    $params[] = $name;
    $types .= "s";
}

if ($description !== null) {
    $fields[] = "description = ?";
    $params[] = $description;
    $types .= "s";
}

// Update only if image sent
if (isset($_FILES["image"])) {
    $fields[] = "image_url = ?";
    $params[] = $newImage;
    $types .= "s";
}

$fieldsStr = implode(", ", $fields);

$sql = "UPDATE categories SET $fieldsStr WHERE category_id = ?";
$types .= "i";
$params[] = $id;

$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);
$stmt->execute();

echo json_encode([
    "success" => true,
    "message" => "Category updated successfully",
    "category_id" => $id,
    "image_url" => $newImage
]);
exit;
?>
