<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require '../../dbconn.php'; // adjust path

$page     = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$limit    = isset($_GET['limit']) ? max(1, intval($_GET['limit'])) : 10;
$search   = isset($_GET['search']) ? trim($_GET['search']) : '';

$offset = ($page - 1) * $limit;

// -------------------------------
// COUNT QUERY
// -------------------------------
$count_sql = "SELECT COUNT(*) AS total FROM categories WHERE active = 1";

$params = [];
$types  = "";

if (!empty($search)) {
    $count_sql .= " AND name LIKE ?";
    $params[] = "%$search%";
    $types   .= "s";
}

$stmt = $conn->prepare($count_sql);

if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$count_result = $stmt->get_result();
$total_count = $count_result->fetch_assoc()['total'];

$stmt->close();

// -------------------------------
// MAIN FETCH QUERY
// -------------------------------
$sql = "SELECT  category_id, name, image_url, description
        FROM categories
        WHERE active = 1";

$params = [];
$types  = "";

if (!empty($search)) {
    $sql .= " AND name LIKE ?";
    $params[] = "%$search%";
    $types   .= "s";
}

$sql .= " LIMIT ? OFFSET ?";
$params[] = $limit;
$params[] = $offset;
$types   .= "ii";

$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);
$stmt->execute();

$result = $stmt->get_result();

$categories = [];

while ($row = $result->fetch_assoc()) {
    $categories[] = $row;
}

$stmt->close();

// -------------------------------
// RESPONSE
// -------------------------------
echo json_encode([
    "success" => true,
    "message" => "Categories fetched successfully",
    "total_count" => $total_count,
    "page" => $page,
    "limit" => $limit,
    "data" => $categories
]);

$conn->close();
?>
