<?php
header("Content-Type: application/json");
require '../dbconn.php';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $admin_id = $_POST["admin_id"];

    $stmt = $conn->prepare("DELETE FROM admin WHERE id = ?");
    $stmt->bind_param("i", $admin_id);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo json_encode(["success" => true, "message" => "Admin deleted successfully"]);
        } else {
            echo json_encode(["success" => false, "message" => "Admin not found"]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "Failed to delete admin"]);
    }

    $stmt->close();
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
}

$conn->close();
?>
